/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.io.File;
import net.ftb.data.Settings;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class CheckInstallPath {
    public String installPath;
    public Action action;
    public String message;
    public String localizedMessage;
    public String setting;

    public CheckInstallPath(String path) {
        this(path, false);
    }

    public CheckInstallPath(String path, boolean calledFromLaunchFrame) {
        this.installPath = path;
        File f = new File(path);
        String defaultLocation = "C:\\FTB";
        String pathRegex = "[\\w\\d:\\\\/ -_\\.]+";
        if (!path.matches(pathRegex)) {
            String s = path.replaceAll(pathRegex, "");
            this.setting = "CIP_badpath";
            if (!Settings.getSettings().getBoolean(this.setting)) {
                this.action = Action.BLOCK;
                this.message = "Unsupported installation directory. Forge does not support following character(s): " + s + " Please select a new location such as " + defaultLocation;
                this.localizedMessage = I18N.getLocaleString("CIP_BADPATH").replace("LIST", s) + defaultLocation;
                Logger.logError(this.message);
            } else {
                this.action = Action.OK;
                Logger.logDebug("ignored: " + this.setting);
            }
        } else if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS && System.getenv("ProgramFiles") != null && path.contains(System.getenv("ProgramFiles"))) {
            this.setting = "CIP_programfiles";
            if (!Settings.getSettings().getBoolean(this.setting)) {
                this.action = Action.BLOCK;
                this.message = "Installing under C:\\Program Files\\ or similar is not supported. Please select a new location such as " + defaultLocation;
                this.localizedMessage = I18N.getLocaleString("CIP_PROGRAMFILES") + defaultLocation;
                Logger.logError(this.message);
            } else {
                this.action = Action.OK;
                Logger.logDebug("ignored: " + this.setting);
            }
        } else if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS && path.contains("Content.IE5")) {
            this.setting = "CIP_internetfiles";
            if (!Settings.getSettings().getBoolean(this.setting)) {
                this.action = Action.BLOCK;
                this.message = "You cannot install FTB to your Temporary Internet Files directory. Please select a new location such as " + defaultLocation;
                this.localizedMessage = I18N.getLocaleString("CIP_INTERNETFILES") + defaultLocation;
                Logger.logError(this.message);
            } else {
                this.action = Action.OK;
                Logger.logDebug("ignored: " + this.setting);
            }
        } else if (f.isDirectory() && !f.canWrite()) {
            this.setting = "CIP_writeprotect";
            if (!Settings.getSettings().getBoolean(this.setting)) {
                this.action = Action.BLOCK;
                this.message = "Could not write to the FTB installation directory. Please select a folder which you have permission to write to.";
                this.localizedMessage = I18N.getLocaleString("CIP_WRITEPROTECT");
                Logger.logError(this.message);
            } else {
                this.action = Action.OK;
                Logger.logDebug("ignored: " + this.setting);
            }
        } else if (calledFromLaunchFrame && !f.exists()) {
            this.setting = "CIP_exists";
            if (!Settings.getSettings().getBoolean(this.setting)) {
                this.action = Action.BLOCK;
                this.message = "FTB installation directory not found!";
                this.localizedMessage = I18N.getLocaleString("CIP_EXISTS");
                Logger.logWarn(this.message);
            } else {
                this.action = Action.OK;
                Logger.logDebug("ignored: " + this.setting);
            }
        } else if (!calledFromLaunchFrame && !f.exists()) {
            f.mkdirs();
            if (!f.exists() || !f.canWrite()) {
                this.setting = "CIP_create";
                if (!Settings.getSettings().getBoolean(this.setting)) {
                    this.action = Action.BLOCK;
                    this.message = "Could not create FTB installation location";
                    this.localizedMessage = I18N.getLocaleString("CIP_CREATE");
                    Logger.logWarn(this.message);
                } else {
                    this.action = Action.OK;
                    Logger.logDebug("ignored: " + this.setting);
                }
            }
        } else {
            this.action = Action.OK;
        }
    }

    public static enum Action {
        OK,
        WARN,
        BLOCK;

    }
}

